/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config.controller;

import frc.emul.config.data.CfgItemSensitivity;
import frc.emul.util.swing.AALabel;
import frc.emul.util.swing.JSpinnerFix;
import frc.emul.vectrex.ui.config.controller.UIJInputSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UISensitivityPane {
    private final CfgItemSensitivity cis;
    private final boolean isX;
    private final boolean on;
    private final ChangeListener cl;

    private UISensitivityPane(CfgItemSensitivity cfgItemSensitivity, ChangeListener changeListener, boolean bl, boolean bl2) {
        this.cis = cfgItemSensitivity;
        this.isX = bl;
        this.cl = changeListener;
        this.on = bl2;
    }

    private void setValue(float f) {
        if (this.getValue() != f) {
            if (this.isX) {
                this.cis.axisX = f;
            } else {
                this.cis.axisY = f;
            }
            if (this.cl != null) {
                this.cl.stateChanged(null);
            }
        }
    }

    private float getValue() {
        return this.isX ? this.cis.axisX : this.cis.axisY;
    }

    private String getCaption() {
        return this.isX ? "Horizontal Axis" : "Vertical Axis";
    }

    private boolean isEnabled() {
        return this.on;
    }

    public static final JComponent buildControlsPane(CfgItemSensitivity cfgItemSensitivity, ChangeListener changeListener, boolean bl, boolean bl2) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        jPanel.add((Component)UISensitivityPane.build(new UISensitivityPane(cfgItemSensitivity, changeListener, true, bl)), "North");
        jPanel.add((Component)UISensitivityPane.build(new UISensitivityPane(cfgItemSensitivity, changeListener, false, bl2)), "South");
        return jPanel;
    }

    public static final JComponent build(final UISensitivityPane uISensitivityPane) {
        final JSlider jSlider = new JSlider(1, 1000, (int)(100.0f * uISensitivityPane.getValue())){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 150;
                return dimension;
            }
        };
        final JSpinnerFix jSpinnerFix = new JSpinnerFix(new SpinnerNumberModel(uISensitivityPane.getValue(), (double)jSlider.getMinimum() / 100.0, (double)jSlider.getMaximum() / 100.0, 0.25));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix.setValue((double)new Integer(jSlider.getValue()).intValue() / 100.0);
            }
        });
        jSpinnerFix.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)jSpinnerFix.getValue()).floatValue();
                jSlider.setValue((int)(f * 100.0f));
                uISensitivityPane.setValue(f);
            }
        });
        if (!uISensitivityPane.isEnabled()) {
            jSlider.setEnabled(false);
            jSpinnerFix.setEnabled(false);
            jSlider.setToolTipText(" Only a relative axis can have its sensibility changed. ");
            jSpinnerFix.setToolTipText(jSlider.getToolTipText());
            AALabel aALabel = new AALabel("--  This is not a relative axis  --");
            aALabel.setHorizontalAlignment(0);
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
            jPanel2.add((Component)aALabel, "North");
            jPanel2.add((Component)new JSeparator(), "South");
            jPanel.add((Component)jPanel2, "North");
        } else {
            jSlider.setMinorTickSpacing(100);
            jSlider.setPaintTicks(true);
        }
        jPanel.add((Component)jSlider, "Center");
        jPanel.add((Component)jSpinnerFix, "East");
        return UIJInputSettings.makeTitledPanel(uISensitivityPane.getCaption(), jPanel);
    }
}

